/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mc_utils;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2491;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5627;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import qouteall.imm_ptl.core.miscellaneous.IPVanillaCopy;

@IPVanillaCopy
public class MyNbtTextFormatter
implements class_5627 {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int field_33271 = 8;
    private static final ByteCollection SINGLE_LINE_ELEMENT_TYPES = new ByteOpenHashSet(Arrays.asList((byte)1, (byte)2, (byte)3, (byte)4, (byte)5, (byte)6));
    private static final class_124 NAME_COLOR = class_124.field_1075;
    private static final class_124 STRING_COLOR = class_124.field_1060;
    private static final class_124 NUMBER_COLOR = class_124.field_1065;
    private static final class_124 TYPE_SUFFIX_COLOR = class_124.field_1061;
    private static final Pattern SIMPLE_NAME = Pattern.compile("[A-Za-z0-9._+-]+");
    private static final String KEY_VALUE_SEPARATOR = String.valueOf(':');
    private static final String ENTRY_SEPARATOR = String.valueOf(',');
    private static final String SQUARE_OPEN_BRACKET = "[";
    private static final String SQUARE_CLOSE_BRACKET = "]";
    private static final String SEMICOLON = ";";
    private static final String SPACE = " ";
    private static final String CURLY_OPEN_BRACKET = "{";
    private static final String CURLY_CLOSE_BRACKET = "}";
    private static final String NEW_LINE = "\n";
    private final String prefix;
    private final int indentationLevel;
    private class_2561 result = class_2561.method_43470((String)"");

    public MyNbtTextFormatter(String prefix, int indentationLevel) {
        this.prefix = prefix;
        this.indentationLevel = indentationLevel;
    }

    public class_2561 apply(class_2520 element) {
        element.method_32289((class_5627)this);
        return this.result;
    }

    public void method_32302(class_2519 element) {
        String string = class_2519.method_10706((String)element.method_10714());
        String string2 = string.substring(0, 1);
        class_5250 text = class_2561.method_43470((String)string.substring(1, string.length() - 1)).method_27692(STRING_COLOR);
        this.result = class_2561.method_43470((String)string2).method_10852((class_2561)text).method_27693(string2);
    }

    public void method_32291(class_2481 element) {
        if (element.method_10698() == 0) {
            this.result = class_2561.method_43470((String)"false").method_27692(NUMBER_COLOR);
            return;
        }
        if (element.method_10698() == 1) {
            this.result = class_2561.method_43470((String)"true").method_27692(NUMBER_COLOR);
            return;
        }
        class_5250 text = class_2561.method_43470((String)"b").method_27692(TYPE_SUFFIX_COLOR);
        this.result = class_2561.method_43470((String)String.valueOf(element.method_10702())).method_10852((class_2561)text).method_27692(NUMBER_COLOR);
    }

    public void method_32301(class_2516 element) {
        class_5250 text = class_2561.method_43470((String)"s").method_27692(TYPE_SUFFIX_COLOR);
        this.result = class_2561.method_43470((String)String.valueOf(element.method_10702())).method_10852((class_2561)text).method_27692(NUMBER_COLOR);
    }

    public void method_32297(class_2497 element) {
        this.result = class_2561.method_43470((String)String.valueOf(element.method_10702())).method_27692(NUMBER_COLOR);
    }

    public void method_32300(class_2503 element) {
        class_5250 text = class_2561.method_43470((String)"L").method_27692(TYPE_SUFFIX_COLOR);
        this.result = class_2561.method_43470((String)String.valueOf(element.method_10702())).method_10852((class_2561)text).method_27692(NUMBER_COLOR);
    }

    public void method_32295(class_2494 element) {
        class_5250 text = class_2561.method_43470((String)"f").method_27692(TYPE_SUFFIX_COLOR);
        this.result = class_2561.method_43470((String)String.valueOf(element.method_10700())).method_10852((class_2561)text).method_27692(NUMBER_COLOR);
    }

    public void method_32293(class_2489 element) {
        class_5250 text = class_2561.method_43470((String)"d").method_27692(TYPE_SUFFIX_COLOR);
        this.result = class_2561.method_43470((String)String.valueOf(element.method_10697())).method_10852((class_2561)text).method_27692(NUMBER_COLOR);
    }

    public void method_32290(class_2479 element) {
        class_5250 text = class_2561.method_43470((String)"B").method_27692(TYPE_SUFFIX_COLOR);
        class_5250 mutableText = class_2561.method_43470((String)SQUARE_OPEN_BRACKET).method_10852((class_2561)text).method_27693(SEMICOLON);
        byte[] bs = element.method_10521();
        for (int i = 0; i < bs.length; ++i) {
            class_5250 mutableText2 = class_2561.method_43470((String)String.valueOf(bs[i])).method_27692(NUMBER_COLOR);
            mutableText.method_27693(SPACE).method_10852((class_2561)mutableText2).method_10852((class_2561)text);
            if (i == bs.length - 1) continue;
            mutableText.method_27693(ENTRY_SEPARATOR);
        }
        mutableText.method_27693(SQUARE_CLOSE_BRACKET);
        this.result = mutableText;
    }

    public void method_32296(class_2495 element) {
        class_5250 text = class_2561.method_43470((String)"I").method_27692(TYPE_SUFFIX_COLOR);
        class_5250 mutableText = class_2561.method_43470((String)SQUARE_OPEN_BRACKET).method_10852((class_2561)text).method_27693(SEMICOLON);
        int[] is = element.method_10588();
        for (int i = 0; i < is.length; ++i) {
            mutableText.method_27693(SPACE).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(is[i])).method_27692(NUMBER_COLOR));
            if (i == is.length - 1) continue;
            mutableText.method_27693(ENTRY_SEPARATOR);
        }
        mutableText.method_27693(SQUARE_CLOSE_BRACKET);
        this.result = mutableText;
    }

    public void method_32299(class_2501 element) {
        class_5250 text = class_2561.method_43470((String)"L").method_27692(TYPE_SUFFIX_COLOR);
        class_5250 mutableText = class_2561.method_43470((String)SQUARE_OPEN_BRACKET).method_10852((class_2561)text).method_27693(SEMICOLON);
        long[] ls = element.method_10615();
        for (int i = 0; i < ls.length; ++i) {
            class_5250 text2 = class_2561.method_43470((String)String.valueOf(ls[i])).method_27692(NUMBER_COLOR);
            mutableText.method_27693(SPACE).method_10852((class_2561)text2).method_10852((class_2561)text);
            if (i == ls.length - 1) continue;
            mutableText.method_27693(ENTRY_SEPARATOR);
        }
        mutableText.method_27693(SQUARE_CLOSE_BRACKET);
        this.result = mutableText;
    }

    public void method_32298(class_2499 element) {
        if (element.isEmpty()) {
            this.result = class_2561.method_43470((String)"[]");
            return;
        }
        if (SINGLE_LINE_ELEMENT_TYPES.contains(element.method_10601()) && element.size() <= 8) {
            String string = ENTRY_SEPARATOR + SPACE;
            class_5250 mutableText = class_2561.method_43470((String)SQUARE_OPEN_BRACKET);
            for (int i = 0; i < element.size(); ++i) {
                if (i != 0) {
                    mutableText.method_27693(string);
                }
                mutableText.method_10852(new MyNbtTextFormatter(this.prefix, this.indentationLevel).apply(element.method_10534(i)));
            }
            mutableText.method_27693(SQUARE_CLOSE_BRACKET);
            this.result = mutableText;
            return;
        }
        class_5250 string = class_2561.method_43470((String)SQUARE_OPEN_BRACKET);
        for (int mutableText = 0; mutableText < element.size(); ++mutableText) {
            class_5250 i = class_2561.method_43470((String)Strings.repeat((String)this.prefix, (int)(this.indentationLevel + 1)));
            i.method_10852(new MyNbtTextFormatter(this.prefix, this.indentationLevel + 1).apply(element.method_10534(mutableText)));
            if (mutableText != element.size() - 1) {
                i.method_27693(ENTRY_SEPARATOR).method_27693(SPACE);
            }
            string.method_10852((class_2561)i);
        }
        if (!this.prefix.isEmpty()) {
            string.method_27693(NEW_LINE).method_27693(Strings.repeat((String)this.prefix, (int)this.indentationLevel));
        }
        string.method_27693(SQUARE_CLOSE_BRACKET);
        this.result = string;
    }

    public void method_32292(class_2487 compound) {
        if (compound.method_33133()) {
            this.result = class_2561.method_43470((String)"{}");
            return;
        }
        class_5250 mutableText = class_2561.method_43470((String)CURLY_OPEN_BRACKET);
        Collection collection = compound.method_10541();
        ArrayList list = Lists.newArrayList((Iterable)compound.method_10541());
        Collections.sort(list);
        collection = list;
        if (!this.prefix.isEmpty()) {
            mutableText.method_27693(NEW_LINE);
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            class_5250 mutableText2 = class_2561.method_43470((String)Strings.repeat((String)this.prefix, (int)(this.indentationLevel + 1))).method_10852(MyNbtTextFormatter.escapeName(string)).method_27693(KEY_VALUE_SEPARATOR).method_27693(SPACE).method_10852(new MyNbtTextFormatter(this.prefix, this.indentationLevel + 1).apply(compound.method_10580(string)));
            if (iterator.hasNext()) {
                mutableText2.method_27693(ENTRY_SEPARATOR).method_27693(this.prefix.isEmpty() ? SPACE : NEW_LINE);
            }
            mutableText.method_10852((class_2561)mutableText2);
        }
        if (!this.prefix.isEmpty()) {
            mutableText.method_27693(NEW_LINE).method_27693(Strings.repeat((String)this.prefix, (int)this.indentationLevel));
        }
        mutableText.method_27693(CURLY_CLOSE_BRACKET);
        this.result = mutableText;
    }

    protected static class_2561 escapeName(String name) {
        if (SIMPLE_NAME.matcher(name).matches()) {
            return class_2561.method_43470((String)name).method_27692(NAME_COLOR);
        }
        String string = class_2519.method_10706((String)name);
        String string2 = string.substring(0, 1);
        class_5250 text = class_2561.method_43470((String)string.substring(1, string.length() - 1)).method_27692(NAME_COLOR);
        return class_2561.method_43470((String)string2).method_10852((class_2561)text).method_27693(string2);
    }

    public void method_32294(class_2491 element) {
    }
}

